<?= GridView::widget([
	// ... more code here
	'columns' => [
		// ... other columns 
		[
			// the attribute
			'attribute' => 'created_at',
			// format the value
			'value' => function ($model) {
				if (extension_loaded('intl')) {
					return Yii::t('app', '{0, date, MMMM dd, YYYY HH:mm}', [$model->created_at]);
				} else {
					return date('Y-m-d G:i:s', $model->created_at);
				}
			},
			// some styling? 
			'headerOptions' => [
				'class' => 'col-md-2'
			],
			// here we render the widget
			'filter' => DateRangePicker::widget([
				'model' => $searchModel,
				'attribute' => 'created_at_range',
				'pluginOptions' => [
				'format' => 'd-m-Y',
				'autoUpdateInput' => false
			]
			])
		],
	]
]); ?>


<?php
use yii\helpers\Html;
use kartik\grid\GridView;
$visible ? $url = 'awards' : $url = 'index';
?>
<div class="awards-record-index">
<?= GridView::widget([
    'dataProvider' => $dataProvider,
    'filterModel' => $searchModel,
    'columns' => [
        ['class' => 'yii\grid\SerialColumn'],
        'id',
        [
            'label'=>'Cell-phone number',
            'value'=>function($model) {
                return $model->user->mobile;
            },
            'visible'=> $visible,
        ],
        //The use of time interval selector-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
       [
            'attribute' => 'created_at', //value does not need to format time if the timestamp type is datetime
            'filterType' => GridView::FILTER_DATE_RANGE,
            'value' => function($model) {
                if ($model->created_at) {
                    return date('Y-m-d H:i:s',$model->created_at);
                }
                return null;
            },
            'filterWidgetOptions' => [
                'startAttribute' => 'created_at_c', //Attribute of start time
                'endAttribute' => 'created_at_e',   //The attributes of the end time
                'convertFormat'=>true, // Importantly, true uses the local - > format time format to convert PHP time format to js time format.
                'pluginOptions' => [
                    'format' => 'yyyy-mm-dd hh:ii:ss',//Date format
                  	  'timePicker'=>true, //Display time
//                        'Time Picker Increment'=>5, //min interval
                     'timePicker24Hour' => true, //24 hour system
                    'locale'=>['format' => 'Y-m-d H:i:s'], //php formatting time
                ]
            ],
        ],
        //The use of single time selector
       
    ],
    'toolbar' => [
        ['content' =>
            Html::a('<i class="glyphicon glyphicon-repeat"></i>', [$url], ['data-pjax' => 0, 'class' => 'btn btn-default', 'title' => 'Refresh']),
        ],
        '{export}',
        '{toggleData}'
    ],
    'exportConfig'=> [
        GridView::EXCEL => ['filename' =>'Lucky draw'],
    ],
    'bordered' => true,
    'striped' => false,
    'condensed' => false,
    'hover' => true,
    'panel' => [
        'type' => GridView::TYPE_DEFAULT
    ]
]); ?>
Amend the $search model to read as follows:
When the create_at type is timestamp:
 public $created_at_c; //start time
public $created_at_e; //End time
public function rules()
{
    return [
        [['created_at'，'created_at_c', 'created_at_e'],'save']//Modify create_at to the rule, otherwise the rule is not valid and the search cannot be executed
    ];
}
Adding code to the search() method can query all data in a certain time interval:

   if ($this->created_at_c && $this->created_at_e) {
            $create_start = strtotime($this->created_at_c);
            $create_end   = strtotime($this->created_at_e);
            $query->andWhere(['between', 'created_at', $create_start, $create_end]);
    }
When the create_at type is datetime:
 public $created_at_c; //start time
public $created_at_e; //End time
public function rules()
{
    return [
        [['created_at'，'created_at_c', 'created_at_e'],'save']
    ];
}
Adding code to the search() method can query all data in a certain time interval:

   if ($this->created_at_c && $this->created_at_e) {
            $query->andWhere(['between', 'created_at', $this->created_at_c, $this->created_at_e]);
    }